#!/usr/local/bin/python
"""
NAME
    create-html.py - wraps HTML page contents with HTML page template

SYNOPSYS
    create-html.py [-t title] template_file source_page_contents output_page

DESCRIPTION
    create-html.py will insert the contents of an HTML page into a supplied
    page template, outputing the results as a final HTML page.

    Command Flags:

    -t title    set the default title to use on all pages
    
                The title of the resulting page is determined by the
                first <h1> for <h2> header encountered in the page
                contents.

    If there is no -t flag, the template's title is left untouched.

MODIFICATION HISTORY
Mnemonic       Rel    Date   Who
create-html    1.0    040614 mpw
    Written.
create-html    1.1    050909 mpw
    Handle source with existing <body> (Docbook generated)

$Id: create-html.py,v 1.5 2014/04/23 14:39:57 mark Exp $

"""
import sys
import re
import getopt

default_title = ""

try:
    opts,args = getopt.getopt(sys.argv[1:],'t:')
    for o,v in opts:
        if o == '-t': default_title = v
except getopt.GetoptError,e:
    print >>sys.stderr,"%s: unknown flag: %s" % (sys.argv[0],e.opt)
    sys.exit(1)

template_file = args[0]
html_in_file = args[1]
html_out_file = args[2]

try:
    template = open(template_file).read()
    html_in = open(html_in_file).read()
    html_out = open(html_out_file,mode="w")
except Exception,e:
    print >>sys.stderr, "%s: unable to open file: %s" %(sys.argv[0],e)
    sys.exit(1)
    
# attempt to modify title to reflect page contents
re_title = re.compile(r'<title>.*?</title>')
re_header = re.compile(r'<h[12]>(.*)</h[12]>')
re_body = re.compile(r'<body.*?>(.*)</body>',re.DOTALL)

match = re_body.search(html_in)
if match != None:
    # page already has body; insert menu template 
    page = match.group(1)
    match = re_body.search(template)
    if match == None:
        print >>sys.stderr,"%s: missing <body> in template file: %s" % \
              (sys.argv[0],template_file)
        sys.exit(1)
    menupage = match.group(1)
    page = menupage.replace("<!-- page contents go here -->",page)
    re_body.search(html_in)
    content = re_body.sub("<body>"+page+"</body>",html_in)
else:
    # needs full page template
    match = re_header.search(html_in)
    # only replace title if default_title specified on command line
    if len(default_title) != 0:
        if match != None:
            header = match.group(1)
            page_title = "<title>"+default_title+" - "+header+"</title>"
        else:
            page_title = "<title>"+default_title+"</title>"
        if re_title.search(template):
            template = re_title.sub(page_title,template)
    content = template.replace("<!-- page contents go here -->",html_in)

html_out.write(content)
