# Makefile for publishing html files from processed html pages
#
# MODIFICATION HISTORY
# Mnemonic		Date	Rel	Who
# www-publish	040615	1.0	mpw
#	Written.
# www-publish   051001  1.1 mpw
#   OBJ dir passed in on make command line
#
# $Id: publish.mk,v 1.5 2014/05/09 08:34:37 mark Exp $

# set target directory
# note, OBJ, PUB-DIR are passed on invokation line
TD := ${subst ${OBJ},${PUB-DIR},${CURDIR}}

# pattern rule to make all targets (directories are ignored)
${TD}/% : %
	if [ ! -d $< ]; then \
		echo -n "Publishing $@ " ; \
		cp $< $@ ; \
	    chmod 755 $@ ; \
		echo "..." ; \
	fi

# define list of  targets (that's everything)
OBJS := ${patsubst %,${TD}/%,${wildcard *}}
OBJS += ${patsubst %,${TD}/%,${wildcard .??*}}

all: ${TD} ${OBJS} 

# make target directory if necessary
${TD}:
	mkdir -p ${TD}
