# Makefile to process and publish web contents
#
#
# make compile - create pages by placing page contents into the standard
#                page template. 
#
# make publish - copy processed pages to web directory, and cgi-bin scripts
#
#
# MODIFICATION HISTORY
# Mnemonic		Date	Rel	Who
# www-publish	040615	1.0	mpw
#	Written.
# www-publish   050103  1.1 mpw
#   Copy contents of cgi-bin directory under ${ROOT} to ${HTTPD-ROOT}
#   when publishing
# www-publish   050107  1.2 mpw
#   Added distclean option to clean contents of live www directories data
#   and cgi-bin
# www-publish   050127  1.3 mpw
#   Supporting linking of html files within multiple directories
# www-publish   050702  1.4 mpw
#   Remove any .bak files left by ispell
# www-publish   050909  1.5 mpw
#   Revised to handle Docbook output in XHTML 
# www-publish   051001  1.6 mpw
#   Support for CVS project (i.e. ignore cvs directories)
# www-publish   051101  1.7 mpw
#   Ensure that make compile fails immediately on error
# www-publish   051101  1.8 mpw
#   Replace explict use of gmake with ${MAKE}
# www-publish   061230      mpw
#   Rehack to use as a make include file, called from
#   a Makefile that sets the required macros
# www-publish   140417      mpw
#   Improvements to template handling for different server OSes
# www-publish   140509      mpw
#   Pattern rules used for relaxed/strict XML checking
#   Templates renamed

# $Id: main.mk,v 1.15 2014/06/02 15:42:16 mark Exp $

# The following make macros must be set:
#
# SITE-ROOT             Root directory of source tree
# SRC                   Location of html files and other material
# OBJ                   Location of staging area
# CGI-BIN-DIR           Location of source cgi-bin programs
#                        cgi-bin programs are copied to 
#                        ${HTTPD-ROOT}/cgi-bin
# HTTPD-ROOT            Root directory of published tree
# PUB-DIR               Location of published html files
# 
# The following macros are optional:
#
# SYSTEM                Identifies target server by OS (.e.g `uname -s`)
# WEB-TOOLS             Location of this set of web tools 
#                        default is ${HOME}/web
# CHKXML-ARGS           Arguments to chk_xml.py/chk_xhtml.py
#                        default is empty
# LINK-DIRS             List of directories (under ${SRC}) which
#                       contain html files for linking
#                        default is empty
# MASTER-TEMPLATE       Name of master template for creating system template
#                        default is empty (in which case the system temlate
#                        is assumed to exist)
#                       CONFIG-${SYSTEM} macros 
# SYSTEM-TEMPLATE       Name of standard site template
#                        default is "system.template"
# CREATE-ARGS           Arguments passed to create-html.py tool
#                        default is empty
# LINK-ARGS             Arguments passed to pagelink.py tool
#                        default is empty

# Templating macros
#
#   If MASTER-TEMPLATE is defined, the SYSTEM-TEMPLATE is created from it, by
#   running the sed commands defined in ${CONFIG-${SYSTEM}}. 

# HTML file syntax checks
#
#  Files with the suffix .html are assumed to be in XHTML and are
#  checked for well formedness and adherence to the standard.
#
#  Files with the suffic .hmlx are only checked for well-formedness.
#  For example, the HTML5 Canvas element in not valid XHTML and can be
#  only checked in a relaxed manner.


# allow override for testing
WEB-TOOLS ?= ${HOME}/web
MAKE-DIR ?= ${WEB-TOOLS}/make
TOOLS-DIR ?= ${WEB-TOOLS}/tools

# set defaults for system template name if not already defined
# SYSTEM-TEMPLATE is copied to HTTP-ROOT so that CGI-BIN programs
# can access its contents for templating their own page data.
SYSTEM-TEMPLATE ?= system.template

.SILENT:

.PHONY: compile publish clean template link cgi-bin sitemap

compile:  link
	if [ ! -d ${OBJ} ]; then  mkdir -p ${OBJ} ; fi
	find ${SRC} -type f \( -name "*.bak" -o -name "*~" \) -delete 
	DIRLIST=`find ${SRC} -name "CVS" -prune -or -type d -print` ; \
	for dir in $${DIRLIST} ; do \
		echo "Compiling for $${dir} ..." ; \
		${MAKE} ${MKFLAGS} -C $${dir} -f ${MAKE-DIR}/compile.mk \
			SRC=${SRC} \
			OBJ=${OBJ} \
			CHKXML-ARGS=${CHKXML-ARGS} \
			CREATE-ARGS=${CREATE-ARGS} \
			SYSTEM-TEMPLATE=${SYSTEM-TEMPLATE} \
			TOOLS-DIR=${TOOLS-DIR} || exit 1; \
	done

publish: cgi-bin
	find ${OBJ} -type d -exec ${MAKE} ${MKFLAGS} -C {} \
		-f ${MAKE-DIR}/publish.mk \
			OBJ=${OBJ}  \
			CGI-BIN-DIR=${CGI-BIN-DIR} \
			ROOT=${CURDIR} \
			SYSTEM-TEMPLATE=${SYSTEM-TEMPLATE} \
			PUB-DIR=${PUB-DIR} \;

# update internal links in directories which contain linked html files
link:
	for dir in ${LINK-DIRS}; do \
		echo "Linking for $${dir}..." ; \
		cd ${SRC}/$${dir}; \
		${TOOLS-DIR}/pagelink.py ${LINK-ARGS} -d $${dir}; \
	done

# if MASTER-TEMPLATE is set, then SYSTEM-TEMPLATE is created by applying
# the contents of CONFIG-${SYSTEM} via sed

ifdef MASTER-TEMPLATE
${SRC}/${SYSTEM-TEMPLATE}: ${SRC}/${MASTER-TEMPLATE}
	if [ ! -z ${CONFIG-${SYSTEM}} ]; then \
		echo "Creating new template [$@] ..." ;\
		sed <$< >$@ -e ${CONFIG-${SYSTEM}} ;\
	else \
		echo "Copying master to system template (no CONFIG)." ;\
		cp $< $@; \
	fi
endif

clean:
	rm -rf ${OBJ} 
ifdef MASTER-TEMPLATE
	rm -f ${SRC}/${SYSTEM-TEMPLATE}
endif

distclean: clean
	rm -rf ${HTTPD-ROOT}
	rm -rf ${PUB-DIR}

# update cgi-bin binaries if required
cgi-bin:
	find $@ -name "CVS" -prune -or -type d \
		-exec ${MAKE} ${MKFLAGS} -C {} -f ${MAKE-DIR}/publish.mk \
			OBJ=${CGI-BIN-DIR} \
			ROOT=${CURDIR} \
			PUB-DIR=${HTTPD-ROOT}/cgi-bin \;

# build new site map and copy to httpd document root
# this is a bit of kludge as the sitemap.xml.gz location has to 
# be hardwired into the config.xml file.  TBFixed.
sitemap:
	python ~/bin/sitemap_gen.py --config=${SITE-ROOT}/config.xml ; \
	if [ $$? -eq 0 ]; then \
		cp ${SRC}/sitemap.xml.gz ${PUB-DIR} ; \
	fi
