//  wminterface.hh for fluxter.
//
//  Copyright (c) 2002 Steve Cooper, stevencooper@isomedia.com
//  Copyright (c) 1998-2000 by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//
#ifndef __WMINTERFACE_HH
#define __WMINTERFACE_HH

#include "Image.hh"
#include "fluxter.hh"
#include "Timer.hh"
#include <vector>

using namespace std;

class BImageControl;
class Resource;
class ToolWindow;
class BaseDisplay;

struct WindowList;


class WMInterface : public TimeoutHandler {

public:
    WMInterface(ToolWindow *);
    virtual ~WMInterface(void);

    void moduleInit(void);

    void removeSticky(Window,int);
    void addSticky(WindowList *);
    void sendWindowToDesktop(Window,int);
    void setWindowFocus(Window);
    bool isIconicState(Window);
    void changeIconState(Window);
    void windowAttributeChange(Window);
  
    int getCurrentDesktop(void);
    void changeDesktop(int);

    void processClientEvents(XEvent Event);
    bool hasWindowAtom(Window win, Atom atom);
    int getWindowWorkspaceID(Window win);
    bool hasFocus(Window win);
    int getNumberOfDesktops(void);
    const vector<Window>& getClients(void);
    void WMNotifyDesktopCount(int);
    void handleWMEvents(XEvent);
    void WMNotifyStartup(void);
    void WMNotifyWindowAdd(Window,int);
    void WMNotifyDel(Window);
    void WMNotifyAttributes(Window);
    void WMNotifyFocus(Window);
    void WMNotifyCurrentWorkspace(int);
    void WMNotifyWorkspaceCount(int);
    void WMNotifyWindowRaise(Window);
    void WMNotifyWindowLower(Window);
    virtual void timeout(void);
    
private:
    void sendClientMessage(Atom, XID);

    ToolWindow *bbtool;
    BTimer *timer;
    vector<Window> winvec;
    
};

#endif /* __WMINTERFACE_HH */
